/** @file   fightercontroller.cpp
 * @brief   Implementation of FighterController - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#include "fightercontroller.h"
#include "utils.h"
#include "warglobals.h"
using namespace eng2d;

namespace WeWantWar {

///
/// Constructors, destructor and operators
/// ======================================
/** Constructor
 */
FighterController::FighterController( GameObject* pObj ) :
  AIController( pObj, WarGlobals::pObjTable->pPlayer ),
  
  m_alerted( false ),
  m_seizeFireCounter( 30 ),
  m_state( STATE_ATTACK ),
  m_attackPhaseLength( 25 ),
  m_evadePhaseLength( 60 )
{
  AIController::m_visualRange = 650;
  AIController::m_attackRange = 150;
}



/** Destructor
 */
FighterController::~FighterController()
{
}




///
/// Public methods
/// ==============

/** updates this controller.
 */
void FighterController::updateAI( bool seeTarget, float dist )
{
  GameObject* pO = this->getGameObject();
  GameObject* pT = this->getTarget();
  
  // If the player is too far away, we wait until he gets close enough.
  if ( this->withinVisualRange() == false ) {
    this->reset();
    this->setCounter( 15 + rand() % 10 );
    return;
  }
  
  // Player is close enough. We start moving.
  this->reset();
  this->forward() = 1;


  if ( m_state == STATE_ATTACK ) {
    // Fly towards the player

    int d = Utils::findTurningDir( pO->position(), pT->position(), pO->angle() );
    this->turn() = 3 * d;
    this->setCounter( 0 );
    
    // If we are within the shooting range, we shoot.
    bool f = Utils::isFacingObject( pO, pT, 50 );
    if ( this->withinAttackRange() && f == true ) {
      this->shoot() = 1;
      this->turn() = 0;
      this->setCounter( 15 );
      m_state = STATE_SHOOT;
      return;
    }
    
  } else if ( m_state == STATE_SHOOT ) {
    m_state = STATE_EVADE;
    this->turn() = ( rand() % 10 < 5 ) ? -1 : 1;
    this->setCounter( m_evadePhaseLength + rand() % 15);

  } else if ( m_state = STATE_EVADE ) {
    m_state = STATE_ATTACK;
    
  }
}

void FighterController::setAttackPhaseLength( int aAttackLength )
{
  m_attackPhaseLength = aAttackLength;
}

void FighterController::setEvadePhaseLength( int aEvadeLength )
{
  m_evadePhaseLength = aEvadeLength;
}

} // end of namespace

/**
 * Version history
 * ===============
 * $Log: fightercontroller.cpp,v $
 * Revision 1.2  2006/03/16 21:33:37  lamminsa
 * Behaviour can have more variation.
 *
 * Revision 1.1.1.1  2006/01/21 23:02:43  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:15:35+02  lamminsa
 * Initial revision
 *
 */
 
